// PageSettingLogo.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingLogo.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "Include\CommonFun.h"


// CPageSettingLogo dialog

IMPLEMENT_DYNAMIC(CPageSettingLogo, CDialog)

CPageSettingLogo::CPageSettingLogo(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingLogo::IDD, pParent)
{

}

CPageSettingLogo::~CPageSettingLogo()
{
}

void CPageSettingLogo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CHECK_LOGO, m_CChkShowLogo);
	DDX_Control(pDX, IDC_EDIT_X, m_EditLogoX);
	DDX_Control(pDX, IDC_EDIT_Y, m_EditLogoY);
	DDX_Control(pDX, IDC_EDIT_COLOR, m_EditLogoColor);
	DDX_Control(pDX, IDC_EDIT_TRANSPARENT, m_EditLogoAlpha);
	DDX_Control(pDX, IDC_EDIT_UPDATALOGO, m_EditUpgradeLogo);
	DDX_Control(pDX, IDC_CBO_CHANNEL_NO, m_cboChannelNum);
	DDX_Control(pDX, IDC_CHECK_SHOWICON, m_ChkShowIcon);
	DDX_Control(pDX, IDC_EDIT_SHOWICON_POSNO, m_EditPosNo);
	DDX_Control(pDX, IDC_EDIT_SHWOICON_ICONTYPE, m_EditIconType);
}


BEGIN_MESSAGE_MAP(CPageSettingLogo, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SETLOGO, &CPageSettingLogo::OnBnClickedButtonSetlogo)
	ON_BN_CLICKED(IDC_BUTTON_SETBROSE, &CPageSettingLogo::OnBnClickedButtonSetbrose)
	ON_BN_CLICKED(IDC_BUTTON_SETUPDATE, &CPageSettingLogo::OnBnClickedButtonSetupdate)
	ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_NO, &CPageSettingLogo::OnCbnSelchangeCboChannelNo)
	ON_BN_CLICKED(IDC_BUTTON_SHOWICON, &CPageSettingLogo::OnBnClickedButtonShowicon)
END_MESSAGE_MAP()


// CPageSettingLogo message handlers

void  CPageSettingLogo::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_SETLOGO, GetText(IDS_SETTING_LOGO));
	SetDlgItemText(IDC_CHECK_LOGO, GetText(IDS_SETTING_LOGOENABLE));
	SetDlgItemText(IDC_STATIC_X, GetText(IDS_SETTING_X));
	SetDlgItemText(IDC_STATIC_Y, GetText(IDS_SETTING_Y));
	SetDlgItemText(IDC_STATIC_COLOR, GetText(IDS_SETTING_COLOR));
	SetDlgItemText(IDC_STATIC_TRANSPARENT, GetText(IDS_SETTING_TRANSPARENT));
	SetDlgItemText(IDC_BUTTON_SETLOGO, GetText(IDS_SETTING_SETLOGO));
	SetDlgItemText(IDC_STATIC_UPDATELOGO, GetText(IDS_SETTING_UPGRADELOGO));
	SetDlgItemText(IDC_BUTTON_SETBROSE, GetText(IDS_SETTING_BROWSELOGO));
	SetDlgItemText(IDC_BUTTON_SETUPDATE, GetText(IDS_SETTING_UPGRADE));
}

int CPageSettingLogo::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
// 	TLOGOPARAM logo;
// 	memset(&logo,0,sizeof(TLOGOPARAM));
// 	if(DEC_ClientGetLogo(m_lLogonID,&logo)==0)
// 	{
// 		if(logo.m_enable)
// 			m_CChkShowLogo.SetCheck(TRUE);
// 		else
// 			m_CChkShowLogo.SetCheck(FALSE);
// 		SetDlgItemInt(IDC_EDIT_X,logo.m_iPosX);
// 		SetDlgItemInt(IDC_EDIT_Y,logo.m_iPosY);
// 		SetDlgItemInt(IDC_EDIT_COLOR,logo.m_iTransparentColor);
// 		SetDlgItemInt(IDC_EDIT_TRANSPARENT,logo.m_iAlpha);
// 	}
	UpdateLogoData();
	CreateChannelCombo(m_lLogonID, &m_cboChannelNum);
	m_EditLogoX.LimitText(5);
	m_EditLogoY.LimitText(5);
	m_EditLogoColor.LimitText(8);
	m_EditLogoAlpha.LimitText(3);
    return 0;
}

void CPageSettingLogo::OnBnClickedButtonSetlogo()
{
	//TLOGOPARAM logo;
	//if(m_CChkShowLogo.GetCheck())
	//	logo.m_enable = 1;
	//else
	//	logo.m_enable = 0;

	//try//ת
	//{
	//	CString strPosX;
	//	GetDlgItem(IDC_EDIT_X)->GetWindowText(strPosX);
	//	logo.m_iPosX = atoi(CT2CA(strPosX));
	//	CString strPosY;
	//	GetDlgItem(IDC_EDIT_Y)->GetWindowText(strPosY);
	//	logo.m_iPosY = atoi(CT2CA(strPosY));
	//	CString strAlpha;
	//	GetDlgItem(IDC_EDIT_TRANSPARENT)->GetWindowText(strAlpha);
	//	logo.m_iAlpha = atoi(CT2CA(strAlpha));
	//	CString strColor;
	//	GetDlgItem(IDC_EDIT_COLOR)->GetWindowText(strColor);
	//	logo.m_iTransparentColor = atoi(CT2CA(strColor));
	//}
	//catch (...)
	//{
	//	MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
	//	return;
	//}

	int iChannel = GetComboData(&m_cboChannelNum);
	ChannelLogoParam tChaLogopar = {0};
	tChaLogopar.iSize = sizeof(ChannelLogoParam);
	if(m_CChkShowLogo.GetCheck())
		tChaLogopar.tLogoParam.m_enable = 1;
	else
		tChaLogopar.tLogoParam.m_enable = 0;
	tChaLogopar.tLogoParam.m_iPosX = GetDlgItemInt(IDC_EDIT_X);
	tChaLogopar.tLogoParam.m_iPosY = GetDlgItemInt(IDC_EDIT_Y);
	if(tChaLogopar.tLogoParam.m_iPosX > 10000 || tChaLogopar.tLogoParam.m_iPosY > 10000)
	{
		MessageBox(GetText(IDS_STRING_COOR_INVALID), _T(""), MB_OK|MB_TOPMOST);
		return;
	}
	tChaLogopar.tLogoParam.m_iAlpha = GetDlgItemInt(IDC_EDIT_TRANSPARENT);
	if(tChaLogopar.tLogoParam.m_iAlpha < 0 || tChaLogopar.tLogoParam.m_iAlpha > 100)
	{
		{
			MessageBox("param error!", _T(""), MB_OK|MB_TOPMOST);
			return;
		}
	}
	tChaLogopar.tLogoParam.m_iTransparentColor = GetDlgItemInt(IDC_EDIT_COLOR);
	if(tChaLogopar.tLogoParam.m_iTransparentColor < 0 || tChaLogopar.tLogoParam.m_iTransparentColor > 0xffffff)
	{
		{
			MessageBox("param error!", _T(""), MB_OK|MB_TOPMOST);
			return;
		}
	}

	/*int iRet = DEC_ClientSetLogo(m_lLogonID,&logo);*/

	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannel, 0, CMD_DEC_CFG_LOGOPARAM, &tChaLogopar, sizeof(ChannelLogoParam));
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
	else if (ERR_POS_X_Y == iRet)
	{
		MessageBox(GetText(IDS_STRING_COOR_INVALID), _T(""), MB_OK|MB_TOPMOST);
	}
	else if (ERR_REPEAT_SET == iRet)
	{
		MessageBox(GetText(IDS_STRING_LOGO_REPEAT_SET), _T(""), MB_OK|MB_TOPMOST);
	} 
	else
	{
		MessageBox(GetText(IDS_STRING_SET_FAILED), _T(""), MB_OK|MB_TOPMOST);
	}
}

void CPageSettingLogo::OnBnClickedButtonSetbrose()
{
// 	CFileDialog dlgFile(TRUE, NULL, NULL, NULL, _T("All Files (*.*)|*.*||"));
// 	CString fileName;
// 	const int c_cMaxFiles = 100;
// 	const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
// 	dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
// 	dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
// 
// 	if (IDOK == dlgFile.DoModal())
// 	{
// 		m_EditUpgradeLogo.SetWindowText(fileName);
// 	}
// 	fileName.ReleaseBuffer();	

	CFileDialog dlgFile(TRUE, NULL, NULL
		, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING
		, _T("All Files (*.*)|*.*||"));
	if(IDOK == dlgFile.DoModal())
	{
		CString fileName = dlgFile.GetPathName();
		m_EditUpgradeLogo.SetWindowText(fileName);
	}
}

void CPageSettingLogo::OnBnClickedButtonSetupdate()
{
	CString szFile;
	GetDlgItem(IDC_EDIT_UPDATALOGO)->GetWindowText(szFile);
	if (szFile.Compare(_T("")) == 0)
	{
		return;
	}
	int iRet = DEC_ClientUpgradeLogo(m_lLogonID,(LPSTR)(LPCTSTR)szFile);
	if(iRet == 0)
	{
		m_dlgUpgrade.DoModal();
	}
	else
	{
		MessageBox(GetText(IDS_UPGRADE_FAIL),  _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
	}
}

void CPageSettingLogo::RecvUpdateMsg()
{
	if (m_dlgUpgrade.m_hWnd)
	{
		m_dlgUpgrade.EndDialog(0);
	}
}


BOOL CPageSettingLogo::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}


void CPageSettingLogo::UpdateLogoData()
{
	int iChannel = GetComboData(&m_cboChannelNum);//m_cboChannelNum.GetCurSel();
	ChannelLogoParam tChaLogopar = {0};
	tChaLogopar.iSize = sizeof(ChannelLogoParam);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannel, 0, CMD_DEC_CFG_LOGOPARAM, &tChaLogopar, sizeof(ChannelLogoParam));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingLogo::UpdateLogoData] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	if(tChaLogopar.tLogoParam.m_enable)
		m_CChkShowLogo.SetCheck(TRUE);
	else
		m_CChkShowLogo.SetCheck(FALSE);
	SetDlgItemInt(IDC_EDIT_X,tChaLogopar.tLogoParam.m_iPosX);
	SetDlgItemInt(IDC_EDIT_Y,tChaLogopar.tLogoParam.m_iPosY);
	SetDlgItemInt(IDC_EDIT_COLOR,tChaLogopar.tLogoParam.m_iTransparentColor);
	SetDlgItemInt(IDC_EDIT_TRANSPARENT,tChaLogopar.tLogoParam.m_iAlpha);
}

void CPageSettingLogo::UpdateIconData()
{
	int iChannel = GetComboData(&m_cboChannelNum);
	int iPosNo = GetDlgItemInt(IDC_EDIT_SHOWICON_POSNO);
	DecShowIcon tInfo = {0};
	tInfo.iSize = sizeof(DecShowIcon);
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, iChannel, iPosNo, CMD_DEC_CFG_SHOWICON, &tInfo, sizeof(DecShowIcon));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingLogo::UpdateIconData] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	if(tInfo.iDisp)
		m_ChkShowIcon.SetCheck(BST_CHECKED);
	else
		m_ChkShowIcon.SetCheck(BST_UNCHECKED);
	SetDlgItemInt(IDC_EDIT_SHWOICON_ICONTYPE,tInfo.iIconType);
}

void CPageSettingLogo::OnCbnSelchangeCboChannelNo()
{
	UpdateLogoData();
	UpdateIconData();
}

void CPageSettingLogo::OnBnClickedButtonShowicon()
{
	int iChannel = GetComboData(&m_cboChannelNum);
	DecShowIcon tInfo = {0};
	tInfo.iSize = sizeof(DecShowIcon);
	if(BST_CHECKED == m_ChkShowIcon.GetCheck()) {
		tInfo.iDisp = 1;
	} else {
		tInfo.iDisp = 0;
	}
	int iPosNo = GetDlgItemInt(IDC_EDIT_SHOWICON_POSNO);
	tInfo.iIconType = GetDlgItemInt(IDC_EDIT_SHWOICON_ICONTYPE);
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannel, iPosNo, CMD_DEC_CFG_SHOWICON, &tInfo, sizeof(DecShowIcon));
	if (0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
	else if (ERR_POS_X_Y == iRet)
	{
		MessageBox(GetText(IDS_STRING_COOR_INVALID), _T(""), MB_OK|MB_TOPMOST);
	}
}
